@extends('blog::_layouts.master')

@section('title', __('messages.global.blog'))

@section('content')


{{-- Header --}}
<header class="pt-24">
  <div class="mx-auto container px-3 py-16">
    <div class="w-full text-center">
      <h1 class="my-4 text-5xl font-bold leading-tight">{{ __('messages.global.blog') }}</h1>
      <p class="leading-normal text-2xl mb-8">{{ __('messages.blog.subtitle') }}</p>
    </div>
  </div>
</header>


{{-- Starting gradient --}}
@include('landing::_layouts/_partials/gradient-start', ['fill' => '#f7fafc'])


{{-- Latest posts --}}
<section class="bg-gray-100 py-32">
  <div class="mx-auto container">
    <div class="mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-16">
      @each('blog::_partials/post', $posts, 'post')
    </div>
  </div>
</section>


{{-- Ending gradient --}}
@include('landing::_layouts/_partials/gradient-end', ['fill' => '#f7fafc'])


@endsection
