<?php

namespace Modules\Blog\Entities;

use Illuminate\Database\Eloquent\Model;

use Backpack\CRUD\app\Models\Traits\CrudTrait;

use Str;

class Tag extends Model
{
    use CrudTrait;
    
    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $fillable = ['name', 'slug'];
    
    protected $hidden = [];
    
    public $timestamps = false;
    
    /***************************************************************************
     * Boot
     **************************************************************************/
     protected static function boot() {
        parent::boot();

        static::creating(function ($tag) {
            $tag->slug = $tag->slug ?? Str::slug($tag->name);
        });
    }
    
    /***************************************************************************
     * Relationships
     **************************************************************************/
    public function posts()
    {
        return $this->belongsToMany(Post::class);
    }
    
    // End of class
}
