<?php

namespace Modules\Blog\Database\Seeders\Dummy;

use Illuminate\Database\Seeder;

use Modules\Blog\Entities\Tag;

class PostsDummyTableSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        factory(\Modules\Blog\Entities\Post::class, 10)->create()->each(function ($post) {

            // Generate image
            $post->addMediaFromUrl('http://lorempixel.com/480/240/')->toMediaCollection();
            
            // Attach Tags
            $n = rand(1, 3);
            $tags = Tag::take($n)->inRandomOrder()->get();
            $post->tags()->attach($tags);
        });
    }
    
    // End of class
}