<?php

namespace Modules\Api\Tests\Feature\Auth;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\User;


class LogoutTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testLogoutUnauthenticated()
    {
        $this->json('get', '/api/auth/logout')
            ->assertStatus(401);
    }

    public function testLogoutSuccessfully()
    {
        $user = User::find(1);
        $token = $user->createToken('')->accessToken;
        $headers = ['Authorization' => "Bearer $token"];

        $this->json('get', '/api/auth/logout', [], $headers)
            ->assertStatus(204);
    }

    // End of class
}
