<?php

namespace Modules\Api\Tests\Feature\Account;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\User;


class UserTest extends TestCase
{

    /***************************************************************************
     * Get User
     **************************************************************************/
    public function testGetUserWithUnauthenticated()
    {
        $this->getJson('/api/account/user')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testGetUserSuccessfully()
    {
        $user = User::find(1);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/user')
            ->assertStatus(200)
            ->assertJson([
                'data' => [
                    'id' => 1,
                    'first_name' => 'Perfect',
                    'last_name' => 'Guy',
                    'email' => 'perfect.guy@example.org',
                    'phone' => '0412111111',
                    'phone_is_private' => 0,
                    'address' => 'Here',
                    'location_zipcode' => '7140',
                    'location_country' => 'BE',
                    'is_premium' => 1,
                ],
            ]);
    }
    /***************************************************************************
     * Update User
     **************************************************************************/
    public function testUpdateUserWithUnauthenticated()
    {
        $this->putJson('/api/account/user')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testUpdateUserWithOrganizationAccess()
    {
        $user = User::find(1);
        $user->account_type = User::ACCOUNT_TYPE_ACCESS;
        $user->save();

        $this->actingAs($user, 'api')
            ->putJson('/api/account/user')
            ->assertStatus(403)
            ->assertJson(['error' => 'account_type_not_allowed']);
    }

    public function testUpdateUserSuccessfully()
    {
        $user = User::find(1);

        $payload = [
            'first_name' => 'John',
            'last_name' => 'Doe',
            'phone' => '+32483023343',
            'phone_is_private' => 1,
            'address' => 'There',
            'location_zipcode' => '75000',
            'location_country' => 'FR',
        ];

        $this->actingAs($user, 'api')
            ->putJson('/api/account/user', $payload)
            ->assertStatus(200)
            ->assertJson([
                'data' => [
                    'id' => 1,
                    'first_name' => 'John',
                    'last_name' => 'Doe',
                    'email' => 'perfect.guy@example.org',
                    'phone' => '0412111111', // not editable
                    'phone_is_private' => 1,
                    'address' => 'There',
                    'location_zipcode' => '75000',
                    'location_country' => 'FR',
                ],
            ]);
    }

    // End of class
}
