<?php

namespace Modules\Api\Tests\Feature\Account;

use Modules\Api\Tests\Feature\TestCase;
use Modules\Common\Entities\User;


class ReportTest extends TestCase
{

    /***************************************************************************
     * Tests
     **************************************************************************/
    public function testGetReportsWithUnauthenticated()
    {
        $this->getJson('/api/account/reports')
            ->assertStatus(401)
            ->assertJson(['message' => 'Unauthenticated.']);
    }

    public function testGetReports()
    {
        $user = User::find(1);

        $this->actingAs($user, 'api')
            ->getJson('/api/account/reports')
            ->assertStatus(200);
    }

    // End of class
}
