<?php

// Auth
Route::group(['prefix' => 'auth'], function () {
    Route::post('register', 'AuthController@register');
    Route::post('login', 'AuthController@login');
    Route::group(['middleware' => ['auth:api']], function () {
        Route::get('logout', 'AuthController@logout');
    });
});

// Authenticated Routes
Route::group(['middleware' => ['auth:api', 'email_verified', 'active']], function () {

    // Account
    Route::group(['prefix' => 'account', 'namespace' => 'Account'], function () {

        // Profile
        Route::get('user', 'UserController@index');

        // NotificationToken
        Route::post('notification_tokens', 'NotificationTokenController@store');

        // Only for individual or organization accounts
        Route::group(['middleware' => ['account:individual|organization']], function () {

            // Profile
            Route::put('user', 'UserController@update');
        });

        // Password
        Route::put('password', 'PasswordController@update');

        // Reports
        Route::group(['prefix' => 'reports'], function () {
            Route::get('/', 'ReportController@index');
        });

        // Deleted Reports
        Route::group(['prefix' => 'deleted_reports'], function () {
            Route::get('/', 'DeletedReportController@index');
        });

        // Only for premium accounts
        Route::group(['middleware' => ['account:individual', 'premium']], function () {
            // Registered Animals
            Route::group(['prefix' => 'registered_animals'], function () {
                Route::get('/', 'RegisteredAnimalController@index');
            });
        });

        // Only for premium or organization access accounts
        Route::group(['middleware' => ['can_access_alerts']], function () {
            // Alerts
            Route::group(['prefix' => 'alerts'], function () {
                Route::get('/', 'AlertController@index');
            });
        });
    });

    // Reports
    Route::group(['prefix' => 'reports'], function () {
        Route::get('/', 'ReportController@index');
        Route::post('/', 'ReportController@store');
        Route::put('/{report}', 'ReportController@update');
        Route::delete('/{report}', 'ReportController@delete');
        Route::get('/{report}', 'ReportController@show');
        Route::get('/{report}/extend_expiration', 'ReportController@extendExpiration');
        Route::get('/{report}/suspend', 'ReportController@suspend');
        Route::get('/{report}/unsuspend', 'ReportController@unsuspend');

        // Abuses
        Route::post('/{report}/abuses', 'Report\AbuseController@store');
    });

    // Places
    Route::group(['prefix' => 'places'], function () {
        Route::get('/', 'PlaceController@index');
    });

    // Only for individual accounts
    Route::group(['middleware' => ['account:individual']], function () {

        // Only for premium users
        Route::group(['middleware' => ['premium']], function () {

            // Registered Animal
            Route::group(['prefix' => 'registered_animals'], function () {
                Route::get('/', 'RegisteredAnimalController@index');
                Route::post('/', 'RegisteredAnimalController@store');
                Route::put('/{registered_animal}', 'RegisteredAnimalController@update');
                Route::delete('/{registered_animal}', 'RegisteredAnimalController@delete');
                Route::get('/{registered_animal}', 'RegisteredAnimalController@show');
            });
        });
    });

    // Only for premium or organization access accounts
    Route::group(['middleware' => ['can_access_alerts']], function () {
        // Alert
        Route::group(['prefix' => 'alerts'], function () {
            Route::post('/', 'AlertController@store');
            Route::put('/{alert}', 'AlertController@update');
            Route::delete('/{alert}', 'AlertController@delete');
        });
    });
});

Route::group(['namespace' => '\Modules\User\Http\Controllers'], function () {
    Route::group(['namespace' => 'Auth', 'prefix' => 'auth'], function () {

        // Authenticated Routes
        Route::group(['middleware' => ['auth:api', 'active']], function () {

            // Verification Phone
            //Route::post('phone/verify', 'VerificationPhoneController@verify');
            //Route::post('phone/resend', 'VerificationPhoneController@resend');
        });

        // Forgot password
        Route::post('password/email', 'ForgotPasswordController@sendResetLinkEmail');
    });
});
