<?php

namespace Modules\Api\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Common\Entities\User as EntitiesUser;

class User extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'gender' => $this->when($this->isCurrentUser(), $this->gender),
            'date_of_birth' => $this->when($this->isCurrentUser(), $this->date_of_birth),
            'email' => $this->email,
            'phone' => $this->canViewPhone() ? $this->phone : null,
            'phone_is_private' => $this->phone_is_private,
            'address' => $this->when($this->isCurrentUser(), $this->address),
            'location_zipcode' => $this->when($this->isCurrentUser(), $this->location_zipcode),
            'location_country' => $this->when($this->isCurrentUser(), $this->location_country),
            'account_type' => $this->when($this->isCurrentUser(), $this->account_type),
            'is_premium' => $this->when($this->isCurrentUser(), $this->is_premium),
            'organization_name' => $this->when($this->isOrganization(), $this->organization_name)
        ];
    }

    private function canViewPhone()
    {
        return $this->isCurrentUser() || $this->phone_is_private == 0;
    }

    private function isCurrentUser()
    {
        return auth()->id() == $this->id;
    }

    private function isOrganization()
    {
        return $this->account_type == EntitiesUser::ACCOUNT_TYPE_ORGANIZATION || $this->account_type == EntitiesUser::ACCOUNT_TYPE_ACCESS;
    }

    // End of class
}
