<?php

namespace Modules\Api\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

use Modules\Api\Http\Resources\Location as LocationResource;
use Modules\Api\Http\Resources\User as UserResource;

use Auth;

class Report extends JsonResource
{

    public function toArray($request)
    {
        $author = $this->user->organization;
        return [
            'id' => $this->id,
            'type' => $this->type,
            'animal_species' => $this->animal_species,
            'animal_condition' => $this->animal_condition,
            'identification_type' => $this->identification_type,
            'identification_number' => $this->when($this->canViewIdentificationNumber(), $this->identification_number),
            'final_location' => $this->when($this->final_location, $this->final_location),
            'comment' => $this->when($this->comment, $this->comment),
            'state' => $this->state,
            'created_at' => $this->created_at,
            'expires_at' => $this->expires_at,
            'location' => new LocationResource($this),
            'images' => $this->images,
            'thumbnail' => $this->thumbnail,
            'link' => $this->link,
            'user' => new UserResource($author),
        ];
    }

    private function canViewIdentificationNumber()
    {
        return $this->user_id == Auth::id();
    }

    // End of class
}
