<?php

namespace Modules\Api\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

use Modules\Api\Http\Resources\Location as LocationResource;


class Place extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'phone' => $this->phone,
            'content' => $this->content,
            'location' => new LocationResource($this),
        ];
    }

    // End of class
}
