<?php

namespace Modules\Api\Http\Controllers\report;

use App\Http\Controllers\Controller;
use Modules\Api\Http\Services\Report\AbuseService;
use Modules\Common\Entities\Report;
use Modules\Common\Http\Requests\AbuseStoreRequest;

class AbuseController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $abuseService;

    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(AbuseService $abuseService)
    {
        $this->abuseService = $abuseService;
    }

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function store(AbuseStoreRequest $request, Report $report)
    {
        // Store abuse
        $this->abuseService->store($report, $request->validated());

        // Return response
        return response()->json(null, 201);
    }

    // End of class
}
