<?php

namespace Modules\Api\Http\Controllers;

use App\Http\Controllers\Controller;

use Modules\Api\Http\Requests\Auth\LoginRequest;
use Modules\Api\Http\Requests\Auth\RegisterRequest;
use Modules\Api\Http\Resources\Token as TokenResource;
use Modules\Api\Http\Resources\User as UserResource;
use Modules\Api\Http\Services\AuthService;

class AuthController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $authService;
    
    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
    }
    
    /***************************************************************************
     * Methods
     **************************************************************************/
    public function register(RegisterRequest $request)
    {
        // Register user
        $user = $this->authService->register($request->validated());
        
        // Return response
        return new UserResource($user);
    }
    
    public function login(LoginRequest $request)
    {
        // Login user
        $token = $this->authService->login($request->validated());

        // Return response
        return new TokenResource($token);
    }

    public function logout()
    {
        // Logout user
        $this->authService->logout();
        
        // Return response
        return response()->noContent();
    }

    // End of class
}
