<?php

namespace Modules\Api\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\Api\Http\Resources\Alert as AlertResource;
use Modules\Api\Http\Services\AlertService;
use Modules\Common\Entities\Alert;
use Modules\Common\Http\Requests\AlertStoreRequest;


class AlertController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $alertService;

    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(AlertService $alertService)
    {
        $this->alertService = $alertService;
    }

    /***************************************************************************
     * Methods
     **************************************************************************/
    public function store(AlertStoreRequest $request)
    {
        // Create resource
        $alert = $this->alertService->store($request->validated());

        // Return response
        return new AlertResource($alert);
    }

    public function update(AlertStoreRequest $request, Alert $alert)
    {
        // Authorize user
        $this->authorize('write', $alert);

        // Update resource
        $alert->update($request->validated());

        // Refresh resource
        $alert->refresh();

        // Return response
        return new AlertResource($alert);
    }

    public function delete(Request $request, Alert $alert)
    {
        // Authorize user
        $this->authorize('write', $alert);

        // Delete resource
        $alert->delete();

        // Return response
        return response()->noContent();
    }

    // End of class
}
