<?php

namespace Modules\Api\Http\Controllers\Account;

use App\Http\Controllers\Controller;

use Modules\Api\Http\Resources\Reports as ReportCollection;

class ReportController extends Controller
{

    public function index()
    {
        // Get reports of the user
        $reports = auth()->user()->reportsWithMembers()->with('user', 'media')->latest()->paginate(25);

        // Return reports
        return new ReportCollection($reports);
    }

    // End of class
}
