<?php

namespace Modules\Api\Http\Controllers\Account;

use App\Http\Controllers\Controller;

use Modules\User\Http\Requests\UpdatePasswordRequest;
use Modules\Api\Http\Services\Account\PasswordService;

class PasswordController extends Controller
{

    /***************************************************************************
     * Attributes
     **************************************************************************/
    protected $passwordService;
    
    /***************************************************************************
     * Constructors
     **************************************************************************/
    public function __construct(PasswordService $passwordService)
    {
        $this->passwordService = $passwordService;
    }
    
    /***************************************************************************
     * Methods
     **************************************************************************/
    public function update(UpdatePasswordRequest $request)
    {
        // Update password
        $this->passwordService->update($request->validated());
        
        // Return response
        return response()->json(null, 200);
    }

    // End of class
}
