<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Common\Entities\User;


class UpdateUserRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'email'                 => 'required|email:rfc,dns|unique:users,email,' . $this->id . ',id,account_type,' . $this->account_type,
            'password'              => 'nullable|string',
            'first_name'            => 'required|regex:/^[\pL\s\-]+$/u|max:30',
            'last_name'             => 'required|regex:/^[\pL\s\-]+$/u|max:30',
            'phone'                 => 'nullable|phone:AUTO|max:20',
            'phone_is_private'      => 'nullable|boolean',
            'address'               => 'nullable|string|max:180',
            'address_is_private'    => 'nullable|boolean',
            'location_zipcode'      => 'nullable|string|max:20',
            'location_country'      => 'nullable|string|max:30',
            'force_premium'         => 'nullable|boolean',
            'email_verified_at'     => 'nullable|date',
            'organization_function' => ['exclude_if:account_type,' . User::ACCOUNT_TYPE_INDIVIDUAL, 'nullable', 'string', 'max:30'],
            'organization_name'     => ['exclude_if:account_type,' . User::ACCOUNT_TYPE_INDIVIDUAL, 'nullable', 'string', 'max:30'],
            'organization_number'   => ['exclude_if:account_type,' . User::ACCOUNT_TYPE_INDIVIDUAL, 'nullable', 'string', 'max:30'],
        ];
    }

    public function attributes()
    {
        return [
            'email' => __('messages.global.email_address'),
            'password' => __('messages.global.password'),
            'first_name' => __('messages.global.first_name'),
            'last_name' => __('messages.global.last_name'),
            'phone' => __('messages.global.phone_number'),
            'phone_is_private' => __('messages.global.hide_phone_number'),
            'address' => __('messages.global.address'),
            'address_is_private' => __('messages.global.hide_address'),
            "organization_function" => __('messages.global.organization_function'),
            "organization_name" => __('messages.global.organization_name'),
            "organization_number" => __('messages.global.organization_number'),
        ];
    }

    // End of class
}
