<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Blog\Entities\Post;

class UpdatePostRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'title' => ['required', 'string', 'max:80'],
            'slug' => ['required', 'string', 'unique:posts,slug,'.$this->id],
            'excerpt' => ['required', 'string', 'max:180'],
            'body' => ['required', 'string'],
            'image' => ['required'],
            'state' => ['required', Rule::in(Post::STATES)],
            'meta_title' => ['nullable', 'string', 'max:100'],
            'meta_description' => ['nullable', 'string', 'max:180'],
        ];
    }

    public function attributes()
    {
        return [
            'title' => __('messages.global.title'),
            'slug' => __('messages.global.slug'),
            'excerpt' => __('messages.global.excerpt'),
            'body' => __('messages.global.body'),
            'image' => __('messages.global.image'),
            'state' => __('messages.global.state'),
            'meta_title' => __('messages.global.meta_title'),
            'meta_description' => __('messages.global.meta_description'),
        ];
    }

    // End of class
}
