<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

use Modules\Common\Entities\Abuse;

class UpdateAbuseRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'state' => ['required', Rule::in(Abuse::STATES)],
        ];
    }

    public function attributes()
    {
        return [
            'state' => __('messages.global.state'),
        ];
    }

    // End of class
}
