<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Common\Entities\User;

class UserReportCrudController extends ReportCrudController
{

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        parent::setup();

        $userId = \Route::current()->parameter('user_id');
        $user = User::findOrFail($userId);

        $title =  __('messages.global.reports') . ' (' . $user->full_name . ')';

        CRUD::setRoute(config('backpack.base.route_prefix') . '/users/' . $userId . '/reports');
        CRUD::setTitle($title);
        CRUD::setHeading($title);
        CRUD::addClause('where', 'user_id', $userId);
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        parent::setupListOperation();

        CRUD::removeButton('export');
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function show($id)
    {
        return parent::show(request()->id);
    }

    // End of class
}
