<?php

namespace Modules\Admin\Http\Controllers\Traits;

use Illuminate\Support\Facades\Route;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;


trait RestoreOperation
{
    /***************************************************************************
     * Actions
     **************************************************************************/
    public function restore($id)
    {
        $this->crud->hasAccessOrFail('update');

        // get entry ID from Request (makes sure its the last ID for nested resources)
        $id = $this->crud->getCurrentEntryId() ?? $id;

        CRUD::getModel()->onlyTrashed()->find($id)->restore();

        return redirect()->back();
    }

    public function forceDelete($id)
    {
        $this->crud->hasAccessOrFail('delete');

        // get entry ID from Request (makes sure its the last ID for nested resources)
        $id = $this->crud->getCurrentEntryId() ?? $id;

        return CRUD::getModel()->onlyTrashed()->find($id)->forceDelete();
    }

    /***************************************************************************
     * Routes
     **************************************************************************/
    public function setupRestoreRoutes($segment, $routeName, $controller)
    {
        Route::get($segment . '/{id}/restore', [
            'as'        => $routeName . '.restore',
            'uses'      => $controller . '@restore',
            'operation' => 'restore',
        ]);
    }

    public function setupForceDeleteRoutes($segment, $routeName, $controller)
    {
        Route::delete($segment . '/{id}/force_delete', [
            'as'        => $routeName . '.force_delete',
            'uses'      => $controller . '@forceDelete',
            'operation' => 'forceDelete',
        ]);
    }

    /***************************************************************************
     * Filters
     **************************************************************************/
    public function addRestoreFilter()
    {
        CRUD::addFilter(
            [
                'type'  => 'simple',
                'name'  => 'withTrashed',
                'label' => __('messages.global.trash'),
            ],
            false,
            function ($value) {
                $this->crud->query = $this->crud->query->onlyTrashed();
                $this->crud->removeAllButtonsFromStack('line');
                $this->crud->addButtonFromView('line', 'show', 'show');
                $this->crud->addButtonFromView('line', 'restore', 'restore');
                $this->crud->addButtonFromView('line', 'forceDelete', 'force_delete');
            }
        );
    }

    // End of class
}
