<?php

namespace Modules\Admin\Http\Controllers\Traits;

use Illuminate\Support\Facades\Route;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;


trait ResendVerificationEmailOperation
{
    /***************************************************************************
     * Actions
     **************************************************************************/
    public function resendVerificationEmail($id)
    {
        $this->crud->hasAccessOrFail('update');

        // get entry ID from Request (makes sure its the last ID for nested resources)
        $id = $this->crud->getCurrentEntryId() ?? $id;

        CRUD::getModel()->find($id)->sendEmailVerificationNotification();

        \Alert::add('success', 'Un lien de vérification a été envoyé.')->flash();

        return redirect()->back();
    }

    /***************************************************************************
     * Routes
     **************************************************************************/
    public function setupResendVerificationEmailRoutes($segment, $routeName, $controller)
    {
        Route::get($segment . '/{id}/resend_verification_email', [
            'as'        => $routeName . '.resend_verification_email',
            'uses'      => $controller . '@resendVerificationEmail',
            'operation' => 'resendVerificationEmail',
        ]);
    }

    // End of class
}
