<?php

namespace Modules\Admin\Http\Controllers\Traits;

use App\Exports\ReportsExport;
use Illuminate\Support\Facades\Route;
use Maatwebsite\Excel\Facades\Excel;

trait ReportsExportOperation
{
    /***************************************************************************
     * Actions
     **************************************************************************/
    public function export()
    {
        $this->crud->hasAccessOrFail('show');

        return Excel::download(new ReportsExport, 'reports.xlsx');
    }

    /***************************************************************************
     * Routes
     **************************************************************************/
    public function setupExportRoutes($segment, $routeName, $controller)
    {
        Route::get($segment . '/export', [
            'as'        => $routeName . '.export',
            'uses'      => $controller . '@export',
            'operation' => 'export',
        ]);
    }

    // End of class
}
