<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Admin\Http\Requests\CreatePostRequest;
use Modules\Admin\Http\Requests\UpdatePostRequest;
use Modules\Blog\Entities\Post;

use Str;

class PostCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        CRUD::setModel("Modules\Blog\Entities\Post");
        CRUD::setRoute(config('backpack.base.route_prefix').'/posts');
        CRUD::setEntityNameStrings(__('messages.global.post'), __('messages.global.posts'));
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {
        CRUD::addColumns($this->fields());
        CRUD::removeColumns([
            'slug', 'body', 'meta_title', 'meta_description', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function setupShowOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Create
     **************************************************************************/
    public function setupCreateOperation()
    {
        CRUD::setValidation(CreatePostRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);

    }

    /***************************************************************************
     * Update
     **************************************************************************/
    public function setupUpdateOperation()
    {
        CRUD::setValidation(UpdatePostRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Fields
     **************************************************************************/
    private function fields()
    {
        return [
            [
                'name' => 'image',
                'label' => __('messages.global.image'),
                'type' => 'image',
                'crop' => true,
            ],
            [
                'name' => 'title',
                'type' => 'text',
                'label' => __('messages.global.title'),
            ],
            [
                'name' => 'slug',
                'type' => 'text',
                'label' => __('messages.global.slug'),
            ],
            [

                'name' => 'excerpt',
                'type' => 'textarea',
                'label' => __('messages.global.excerpt'),
            ],
            [
                'name' => 'body',
                'type' => 'tinymce',
                'label' => __('messages.global.body'),
            ],
            [
                'name' => 'tags',
                'type' => 'select_multiple',
                'label' => __('messages.global.tags'),
                'entity' => 'tags',
                'attribute' => 'name',
                'pivot' => true,
            ],
            [
                'name' => 'state',
                'type' => 'select_from_array',
                'label' => __('messages.global.state'),
                'options' => [
                    Post::STATE_PENDING => __('messages.post_state.' . Post::STATE_PENDING),
                    Post::STATE_PUBLISHED => __('messages.post_state.' . Post::STATE_PUBLISHED),
                ],
                'default' => Post::STATE_PENDING,
            ],
            [
                'name' => 'meta_title',
                'type' => 'text',
                'label' => __('messages.global.meta_title'),
            ],
            [
                'name' => 'meta_description',
                'type' => 'text',
                'label' => __('messages.global.meta_description'),
            ],
            [
                'name' => 'created_at',
                'type' => 'datetime',
                'label' => __('messages.global.created_at'),
            ],
            [
                'name' => 'updated_at',
                'type' => 'datetime',
                'label' => __('messages.global.updated_at'),
            ],
        ];
    }

    // End of class
}
