<?php

namespace Modules\Admin\Http\Controllers;

use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Modules\Admin\Http\Requests\CreatePlaceRequest;

use Modules\Common\Entities\Place;
use Modules\Common\Entities\PremiumCity;

class PlaceCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;

    /***************************************************************************
     * Setup
     **************************************************************************/
    public function setup()
    {
        CRUD::setModel("Modules\Common\Entities\Place");
        CRUD::setRoute(config('backpack.base.route_prefix') . '/places');
        CRUD::setEntityNameStrings(__('messages.global.place'), __('messages.global.places'));
    }

    /***************************************************************************
     * List
     **************************************************************************/
    public function setupListOperation()
    {

        CRUD::addColumns($this->fields());
        CRUD::removeColumns([
            'phone', 'content', 'location_address', 'location_latitude',
            'location_longitude', 'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Show
     **************************************************************************/
    public function setupShowOperation()
    {
        CRUD::addColumns($this->fields());
    }

    /***************************************************************************
     * Create
     **************************************************************************/
    public function setupCreateOperation()
    {
        CRUD::setValidation(CreatePlaceRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);
        $this->data['widgets']['after_content'] = [
            [
                'type' => 'addressCrud'
            ]
        ];
    }

    /***************************************************************************
     * Update
     **************************************************************************/
    public function setupUpdateOperation()
    {
        CRUD::setValidation(CreatePlaceRequest::class);
        CRUD::addFields($this->fields());
        CRUD::removeFields([
            'created_at', 'updated_at',
        ]);
    }

    /***************************************************************************
     * Fields
     **************************************************************************/
    private function fields()
    {
        return [
            [
                'name' => 'name',
                'type' => 'text',
                'label' => __('messages.global.name'),
            ],
            [
                'name' => 'type',
                'type' => 'select_from_array',
                'label' => __('messages.global.place_type'),
                'allows_null' => true,
                'options' => [
                    Place::TYPE_VETERINARY => __('messages.place_type.' . Place::TYPE_VETERINARY),
                    Place::TYPE_SHELTER => __('messages.place_type.' . Place::TYPE_SHELTER),
                    Place::TYPE_ROAD => __('messages.place_type.' . Place::TYPE_ROAD),
                    Place::TYPE_POLICE => __('messages.place_type.' . Place::TYPE_POLICE),
                    Place::TYPE_CREAVES => __('messages.place_type.' . Place::TYPE_CREAVES),
                ],
            ],
            [
                'name' => 'phone',
                'type' => 'text',
                'label' => __('messages.global.phone_number'),
            ],
            [
                'name' => 'content',
                'type' => 'textarea',
                'label' => __('messages.global.content'),
            ],
            [
                'name' => 'zipcodes',
                'type' => 'text',
                'label' => __('messages.global.zipcodes'),
            ],
            [
                'name' => 'country',
                'type' => 'select_from_array',
                'label' => __('messages.global.country'),
                'allows_null' => true,
                'options' => [
                    PremiumCity::COUNTRY_BELGIUM => __('messages.countries.' . PremiumCity::COUNTRY_BELGIUM),
                    PremiumCity::COUNTRY_FRANCE => __('messages.countries.' . PremiumCity::COUNTRY_FRANCE),
                ],
            ],
            [
                'name' => 'location_address',
                'type' => 'text',
                'label' => __('messages.global.address'),
                'attributes' => [
                    'id' => 'location_address',
                    'onFocus' => 'geolocate()',
                ],
            ],
            [
                'name' => 'location_latitude',
                'type' => 'number',
                'label' => __('messages.global.latitude'),
                'decimals' => 11,
                'attributes' => [
                    'id' => 'location_latitude',
                    'step' => 'any',
                ],
            ],
            [
                'name' => 'location_longitude',
                'type' => 'number',
                'label' => __('messages.global.longitude'),
                'decimals' => 11,
                'attributes' => [
                    'id' => 'location_longitude',
                    'step' => 'any',
                ],
            ],
            [
                'name' => 'created_at',
                'type' => 'datetime',
                'label' => __('messages.global.created_at'),
            ],
            [
                'name' => 'updated_at',
                'type' => 'datetime',
                'label' => __('messages.global.updated_at'),
            ],
        ];
    }

    // End of class
}
