<?php

namespace Modules\Admin\Http\Controllers;

use Illuminate\Routing\Controller;

use Modules\Blog\Entities\Post;
use Modules\Common\Entities\User;
use Modules\Common\Entities\Report;
use Modules\Common\Entities\Abuse;

class AdminController extends Controller
{

    protected $data = []; // the information we send to the view

    /**
     * Create a new controller instance.
     */
    public function __construct()
    {
        $this->middleware(backpack_middleware());
    }

    /**
     * Show the admin dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {
        $this->data['title'] = trans('backpack::base.dashboard'); // set the page title
        $this->data['breadcrumbs'] = [
            trans('backpack::crud.admin')     => backpack_url('dashboard'),
            trans('backpack::base.dashboard') => false,
        ];
        $this->data['countUsers'] = User::count();
        $this->data['countReports'] = Report::count();
        $this->data['countPosts'] = Post::count();
        $this->data['countWaitingAbuses'] = Abuse::waiting()->count();

        return view(backpack_view('dashboard'), $this->data);
    }

    /**
     * Redirect to the dashboard.
     *
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function redirect()
    {
        // The '/admin' route is not to be used as a page, because it breaks the menu's active state.
        return redirect(backpack_url('dashboard'));
    }

    // End of class
}
